<?php
/**
 * Enqueue script and styles for child theme
 */
function woodmart_child_enqueue_styles() {
	wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', array( 'woodmart-style' ), woodmart_get_theme_info( 'Version' ) );
}
add_action( 'wp_enqueue_scripts', 'woodmart_child_enqueue_styles', 10010 );


/*
غیر فعال کردن اپدیت خودکار
 */
add_filter( 'auto_update_plugin', '__return_false' );
add_filter( 'auto_update_theme', '__return_false' );
/*
غیر فعال کردن اپدیت خودکار
 */

/*
غیر فعال کردن پیغام آپدیت
 */

function remove_core_updates(){
global $wp_version;return(object) array('last_checked'=> time(),'version_checked'=> $wp_version,);
}
add_filter('pre_site_transient_update_core','remove_core_updates'); //hide updates for WordPress itself
add_filter('pre_site_transient_update_plugins','remove_core_updates'); //hide updates for all plugins
add_filter('pre_site_transient_update_themes','remove_core_updates'); //hide updates for all themes

/*
غیر فعال کردن پیغام آپدیت
 */

/*شورت کد هاید کردن پیام ها*/
add_action('admin_head', 'bc_disable_notice'); function bc_disable_notice() { ?> <style> .notice ,.update-nag, .updated, .error, .is-dismissible { display: none;} </style> <?php }
/*شورت کد هاید کردن پیام ها*/

remove_action( 'shutdown', 'wp_ob_end_flush_all', 1 );
add_action( 'shutdown', function() {
   while ( @ob_end_flush() );
} );

function my_move_post () {
    global $menu;
   $menu[31] = $menu[25]; 
   unset($menu[25]); 
}
add_action('admin_menu', 'my_move_post');

add_filter( 'rank_math/frontend/remove_credit_notice', '__return_true' );



function add_table_of_contents_to_top($content) {
    if (is_single() && in_the_loop() && is_main_query() && get_post_type() === 'post') {
        preg_match_all('/<h2[^>]*>(.*?)<\/h2>/i', $content, $matches);
        if (!empty($matches[1])) {
            $toc = '<div class="custom-toc-wrapper">';
            $is_mobile = wp_is_mobile();            
            if ($is_mobile) {
                $toc .= '<div class="custom-toc-header" id="custom-toc-header">فهرست مطالب <span class="toc-arrow">▼</span></div>';
                $toc .= '<div class="custom-toc" id="custom-toc" style="max-height:0; overflow:hidden; padding:0;">';
            } else {
                $toc .= '<div class="custom-toc-header" id="custom-toc-header">فهرست مطالب <span class="toc-arrow">▲</span></div>';
                $toc .= '<div class="custom-toc" id="custom-toc" style="max-height:none; overflow:visible; padding:15px;">';
            }           
            $toc .= '<ul style="list-style-type: disc; padding-left: 20px;">'; // اضافه کردن استایل بولت
            foreach ($matches[1] as $index => $heading) {
                $heading_text = trim(strip_tags($heading));
                if (!empty($heading_text)) {
                    $id = 'section-' . ($index + 1);
                    $toc .= '<li><a href="#' . esc_attr($id) . '">' . esc_html($heading_text) . '</a></li>';
                    $content = preg_replace('/<h2([^>]*)>' . preg_quote($heading, '/') . '<\/h2>/', '<h2 id="' . $id . '"$1>' . $heading . '</h2>', $content, 1);
                }
            }

            $toc .= '</ul></div></div>';
            $content = $toc . $content;
        }
    }
    return $content;
}
add_filter('the_content', 'add_table_of_contents_to_top');

